	.text
	.code 32

	.global	MakeSINTable
	.extern SIN

@=====================================
@	Calculate SIN LUT table (called at boot, before branching to main code)
@	Thanks to UFC for this.
@=====================================
MakeSINTable:
        stmfd   sp!, {r0-r6}
        ldr             r3, =SIN
        mov             r4, #256                        @ 256 angles, plus a quarter circle so we can use it as a cos table too (changed by LG)
        mov             r0, #0x06000000 @ we'll use vram for our temp storage
        mov             r1, r0
        add             r1, r1, #20             @ plus 20 bytes is where bios will save the result
        mov             r2, #256                        @ store 1<<8 in the yscale parameter so our numbers are good
        strh            r2, [r0, #14]
        mov             r2, #1                  @ r2 is how many times to calculate when we do the bios call
        mov             r5, #0                  @ start angle
LUTloop:
        strh            r5, [r0, #16]           @ store the angle in the input parms
        stmfd   sp!, {r0-r3}            @ push regs
        swi             0x0e0000                        @ bios call
        ldmfd   sp!, {r0-r3}            @ pop regs
        ldrh            r6, [r1, #4]            @ use the PB value, it's equivalent to sin(a)
        strh            r6, [r3], #2            @ store the value to our table and postinc the pointer
        add             r5, r5, #256            @ 512 angles into ffff possible is 128 steps per new angle
        subs            r4, r4, #1
        bne             LUTloop
        ldmfd   sp!, {r0-r6}
        bx              lr
        
        
   
   
   
   
   
   
   
   
   